

black='\E[30;50m'
red='\E[31;50m'
green='\E[32;50m'
yellow='\E[33;50m'
blue='\E[34;50m'
magenta='\E[35;50m'
cyan='\E[36;50m'
white='\E[37;50m'

bold='\033[1m'

function disable_color_print(){
	black=
	red=
	green=
	yellow=
	blue=
	magenta=
	cyan=
	white=

	bold=
}

# cecho (color echo) prints text in color.
# first parameter should be the desired color followed by text
function cecho (){  
  echo -en $1
  shift
  echo $*
  tput sgr0
  return
}

# becho (color echo) prints text in bold.
becho (){
  echo -en $bold
  echo $*
  tput sgr0
  return
}

function get_yn(){
        yn=$defyn
	
        while [  -z $yn ] ; do
		echo -en $blue
                read -p "$* [yn]:" yn
		tput sgr0
		if [ ! -z $yn ] ; then
			if [ $yn != y ] ; then
				if [ $yn != n ] ; then
					yn=
				fi
			fi
		fi
        done
}

function fatal(){
	echo -en $red
        echo FATAL: $*
	tput sgr0
        exit 1
}

function warning(){
	echo -en $yellow
        echo WARNING: $*
	tput sgr0
}

function info(){
        becho INFO: $*
}

function info_red(){
	echo -ne $red
        echo INFO: $*
        tput sgr0
}

function info_green(){
	echo -ne $green
        echo INFO: $*
        tput sgr0
}

function success(){
        echo -en $green
        echo OK: $*
        tput sgr0
}

function failure(){
        echo -en $red
        echo FAILED: $*
        tput sgr0
}

function header(){
	echo -en $magenta
	echo  "============================================================"
	echo $*
	echo  "============================================================"
        tput sgr0
}

function get_val_or_null(){
        val=""
	echo -en $blue
	read -p "$* : " val
	tput sgr0
}
function get_val(){
        val=""
	if [ "$1" = "-d" ] ; then
		default=$2
		shift;shift
	fi
        while [  -z $val ] ; do
                echo -en $blue
                read -p "$* [$default]: " val
                tput sgr0
                if [ -z $val ] ; then
			if [ -n $default ] ; then
				val=$default
			fi
		fi
        done
}

function unload_module(){
        mod=$1
        modprobe -r $mod
        if [ $? -eq 0 ] ; then
                success module $mod unloaded
        else
                fatal module $mod failed to unload
        fi
}
function load_module(){
        mod=$1
        modprobe $mod
        if [ $? -eq 0 ] ; then
                success module $mod loaded
        else
                fatal module $mod failed to load
        fi
}
function check_module(){
        mod=$1
        lsmod|grep $mod > /dev/null 2>&1
        if [ $? -eq 0 ] ; then
                info_green module $mod is loaded
        else
                info_green module $mod is not loaded
        fi
}



function info_rpm(){
	rpm_name=$1
	if [ -z $rpm_name ] ; then
		info_red "no rpm name was passed"
		return 1
	fi
	verbose=$2
	if [ -z $verbose ] ; then
		verbose=0
	fi
	rpm -q $rpm_name > /dev/null 2>&1
	if [ $? -eq 0 ] ; then
		info_green "rpm $rpm_name is installed"
		rpm -qi $rpm_name
		if [ $verbose -ne 0 ] ; then
			echo $rpm_info
			info "rpm files:"
			info "-----------"
			rpm -ql $rpm_name
			info "rpm scripts:"
			info "-----------"
			rpm -q --scripts $rpm_name
		fi
	else
		info_red "rpm $rpm_name is NOT installed"
		return 1
	fi
	return 0
}

get_ib_netscripts(){
        ib_netscripts=
        if [ -z $netscript_dir ] ; then
                return
        fi
        for ns in $(ls $netscript_dir/ifcfg-ib?.???? 2>/dev/null) ; do
                _ib_if=$(basename $ns)
                _ib_if=$(echo $_ib_if|cut -f2 -d-)
                pkey=$(echo $_ib_if|cut -f2 -d.)
                printf "%d" 0x$pkey > /dev/null 2>&1
                if [ $? -eq 0 ] ; then
                        ib_netscripts="$ib_netscripts $_ib_if"
                fi
        done
}

if [ -f /etc/redhat-release ] ; then
        netscript_dir=/etc/sysconfig/network-scripts/
elif [ -f /etc/SuSE-release ] ; then
        netscript_dir=/etc/sysconfig/network/
fi

